#include "ConnectionForm.h"
#include "MainForm.h"
#include "TableData.h"

TableData::TableData(QWidget *parent) : QFrame(parent)
{
	this->CreateAction();
	this->SetLayout();
}

void TableData::SetLayout()
{
	this->setFrameStyle( QFrame::StyledPanel | QFrame::Sunken );
    this->setLineWidth( 2 );

	this->toolBar = new QToolBar(this);
	this->toolBar->addAction(this->addRowAction);
	this->toolBar->addAction(this->delRowAction);
	this->toolBar->addAction(this->excuteAction);
	
	this->tableView = new QTableView(this);

	this->box = new QVBoxLayout( this );
    this->box->setSpacing(0);
    this->box->setMargin(0);
    this->box->addWidget(this->toolBar);
    this->box->addWidget(this->tableView);
}

void TableData::CreateAction()
{
	MainForm* main = (MainForm*)(this->parent()->parent());
	
	this->addRowAction = new QAction(QIcon("images/plus.png"), tr("Add Row"), this);
	connect(addRowAction, SIGNAL(triggered()), main, SLOT(InsertRowInTableModel()));

	this->delRowAction = new QAction(QIcon("images/minus.png"), tr("Del Row"), this);
	connect(delRowAction, SIGNAL(triggered()), main, SLOT(DeleteRowInTableModel()));

	this->excuteAction = new QAction(QIcon("images/excute.png"), tr("Excute"), this);
	connect(excuteAction, SIGNAL(triggered()), main, SLOT(ExcuteTableData()));
}

void TableData::Test()
{
	QMessageBox::warning(this, "Can't Delete", tr("Hello Everyone"), QMessageBox::Ok);
}
